unit Krok6;

interface

uses
  ZamwieniaInterfejsy;

type
  TRealizacjaZamwienia = class
  private
    FWeryfikacjaZamwienia: IWeryfikacjaZamwienia;
  public
    constructor Create(aWeryfikacjaZamwienia: IWeryfikacjaZamwienia);
    procedure ProcessOrder(aZamwienie: IZamwienie);
  end;

procedure RealizujZamwienia6;

implementation

uses
  System.SysUtils, Spring.Container, Spring.Services;

procedure RealizujZamwienia6;
var
  Zamwienie: IZamwienie;
  WeryfikacjaZamwienia: IWeryfikacjaZamwienia;
  RealizacjaZamwienia: TRealizacjaZamwienia;
begin
  WeryfikacjaZamwienia := ServiceLocator.GetService<IWeryfikacjaZamwienia>;
  RealizacjaZamwienia := TRealizacjaZamwienia.Create(WeryfikacjaZamwienia);
  try
    Zamwienie := ServiceLocator.GetService<IZamwienie>;
    RealizacjaZamwienia.ProcessOrder(Zamwienie);
  finally
    RealizacjaZamwienia.Free;
  end;
end;

constructor TRealizacjaZamwienia.Create(aWeryfikacjaZamwienia: IWeryfikacjaZamwienia);
begin
  inherited Create;
  FWeryfikacjaZamwienia := aWeryfikacjaZamwienia;
end;

procedure TRealizacjaZamwienia.ProcessOrder(aZamwienie: IZamwienie);
begin
  FWeryfikacjaZamwienia.WeryfikujZamwienie(aZamwienie);
end;

end.

